package com.icetech.report.service.screen;


import com.icetech.report.domain.entity.screen.ScreenPartitionPark;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 屏幕分区车场表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-06
 */
public interface ScreenPartitionParkService extends IBaseService<ScreenPartitionPark> {

    /**
     * Description: 根据ID查询 屏幕分区车场表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param id 对象id
     * @return ScreenPartitionPark
     */
    ScreenPartitionPark getScreenPartitionParkById(Long id);

    /**
     * Description: 新增  屏幕分区车场表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addScreenPartitionPark(ScreenPartitionPark entity);

    /**
     * Description: 修改 屏幕分区车场表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyScreenPartitionPark(ScreenPartitionPark entity);

    /**
     * Description: 删除  屏幕分区车场表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeScreenPartitionParkById(Long id);
}
