package com.icetech.report.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.report.TempCarReportService;
import com.icetech.report.dao.TempCarReportMapper;
import com.icetech.report.domain.entity.TempCarReport;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-09-08
 */
@Service("tempCarReportService")
public class TempCarReportServiceImpl extends BaseServiceImpl<TempCarReportMapper, TempCarReport> implements TempCarReportService {


    @Override
    public List<TempCarReport> getCarReportList(Integer parkId, Date startTime, Date endTime) {
        return list(Wrappers.lambdaQuery(TempCarReport.class)
                .eq(TempCarReport::getParkId, parkId)
                .ge(TempCarReport::getPayDate, startTime)
                .le(TempCarReport::getPayDate, endTime));
    }
}
