package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkOtherIncomeService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.dao.ParkOtherIncomeMapper;
import com.icetech.report.domain.entity.ParkOtherIncome;
import com.icetech.report.domain.vo.IncomeVo;
import com.icetech.third.anno.DS_SLAVE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场其他收入 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-01
 */
@Service
public class ParkOtherIncomeServiceImpl extends BaseServiceImpl<ParkOtherIncomeMapper, ParkOtherIncome> implements ParkOtherIncomeService {

    @Autowired
    private ParkOtherIncomeMapper parkOtherIncomeMapper;

    /**
     * Description: 根据ID查询 车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param id 对象id
     * @return ParkOtherIncome
     */
    @Override
    public ParkOtherIncome getParkOtherIncomeById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkOtherIncome(ParkOtherIncome entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkOtherIncome(ParkOtherIncome entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场其他收入对象信息 <br>
     * Version1.0 2023-11-01 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkOtherIncomeById(Long id) {
        return removeById(id);
    }

    @Override
    @DS_SLAVE
    public BigDecimal getYearOtherAmount(Integer year) {
        return parkOtherIncomeMapper.selectYearOtherAmount(year);
    }

    @Override
    @DS_SLAVE
    public List<IncomeVo> getOtherYear(Integer year) {
        return parkOtherIncomeMapper.selectOtherYear(year);
    }

    @Override
    @DS_SLAVE
    public List<IncomeVo> getOtherAmountMonth(Integer month) {
        return parkOtherIncomeMapper.selectOtherAmountMonth(month);
    }

}
