package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkAdvertIncomeService;
import com.icetech.report.dao.ParkAdvertIncomeMapper;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.domain.entity.ParkAdvertIncome;
import com.icetech.report.domain.vo.AdvertReportVo;
import com.icetech.report.domain.vo.AdvertVo;
import com.icetech.third.anno.DS_SLAVE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场广告收益表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-18
 */
@Service
public class ParkAdvertIncomeServiceImpl extends BaseServiceImpl<ParkAdvertIncomeMapper, ParkAdvertIncome> implements ParkAdvertIncomeService {

    @Autowired
    private ParkAdvertIncomeMapper parkAdvertIncomeMapper;

    /**
     * Description: 根据ID查询 车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param id 对象id
     * @return ParkAdvertIncome
     */
    @Override
    public ParkAdvertIncome getParkAdvertIncomeById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkAdvertIncome (ParkAdvertIncome entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkAdvertIncome (ParkAdvertIncome entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场广告收益表对象信息 <br>
     * Version1.0 2023-10-18 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkAdvertIncomeById (Long id) {
        return removeById(id);
    }

    @Override
    public List<AdvertVo> getAdvertIncome(Long reportDate) {
        return parkAdvertIncomeMapper.selectAdvertIncome(reportDate);
    }

    @Override
    @DS_SLAVE
    public List<AdvertReportVo> getReportYear(Integer year) {
        return parkAdvertIncomeMapper.selectReportYear(year);
    }

    @Override
    public List<AdvertReportVo> getReportMonth(Integer month) {
        return parkAdvertIncomeMapper.selectReportMonth(month);
    }

    @Override
    @DS_SLAVE
    public BigDecimal getSumAmount(int year) {
        return parkAdvertIncomeMapper.selectSumAmountBy(year);
    }

}
