package com.icetech.report.dao;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.report.domain.entity.PaymentRebateDayReport;
import com.icetech.report.domain.vo.IncomeVo;
import com.icetech.report.domain.vo.RebateVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支付返利日结表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-23
 */
@Mapper
public interface PaymentRebateDayReportMapper extends SuperMapper<PaymentRebateDayReport> {


    List<RebateVo> selectYesterdayPayRebate(@Param("reportDay") Long reportDay);


    BigDecimal selectYearSumRebate(@Param("year") int year);


    List<IncomeVo> selectRebateYearData(@Param("year") Integer year);

    List<IncomeVo> selectRebateMonthData(@Param("yearAndMonth") Integer yearAndMonth);

}