package com.icetech.report.dao;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.report.domain.entity.ParkReportStatics;
import com.icetech.report.domain.vo.ElectronAmountPayNumVo;
import com.icetech.report.domain.vo.ParkChannelReportVo;
import com.icetech.report.domain.vo.ParkChannelStatisticsVo;
import com.icetech.report.domain.vo.ParkPayReportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场统计营分析报表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-17
 */
@Mapper
public interface ParkReportStaticsMapper extends SuperMapper<ParkReportStatics> {
    ParkChannelStatisticsVo selectParkChannelsStatistics(@Param("reportDate") Long reportDate);

    BigDecimal selectTotalPayAmount(@Param("reportDate") Long reportDate);

    ElectronAmountPayNumVo selectElectronAmountPayNum(@Param("reportDate") Long reportDate);

    List<ParkPayReportVo> selectParkPayMonth(@Param("month") Integer month);

    List<ParkPayReportVo> selectParkPayYear(@Param("month") Integer year);

    List<ParkChannelReportVo> selectParkNumsYearList(@Param("startTime") String startTime, @Param("endTime") String endTime);

    List<ParkChannelReportVo> selectParkNumsMonthList(@Param("startTime") String startTime, @Param("endTime") String endTime);

}