package com.icetech.report.dao;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.report.domain.entity.ParkOtherIncome;
import com.icetech.report.domain.vo.IncomeVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场其他收入 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-01
 */
@Mapper
public interface ParkOtherIncomeMapper extends SuperMapper<ParkOtherIncome> {


    BigDecimal selectYearOtherAmount(@Param("year") Integer year);

    List<IncomeVo> selectOtherYear(@Param("year") Integer year);


    List<IncomeVo> selectOtherAmountMonth(@Param("month") Integer month);
}