package com.icetech.report.domain.entity.screen;

import com.baomidou.mybatisplus.annotation.*;
import lombok.*;

import java.io.Serializable;
import java.util.Date;

/**
 * 屏幕表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-06
 */
@Builder
@AllArgsConstructor
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_screen")
public class Screen implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 屏幕名称
     */
    private String name;

    /**
     * 设备编号
     */
    private String deviceNum;

    /**
     * 型号名称
     */
    private String modelName;

    /**
     * 状态:0在线;1未在线
     */
    private Integer status;

    /**
     * 级别
     */
    private Integer level;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 删除时间
     */
    private Long deleteTime;

    /**
     * 乐观锁
     */
    private Integer version;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 更新人
     */
    private String updateUser;


}
