package com.icetech.report.domain.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 端云业务数据对比汇总
 * </p>
 *
 * @author fangct
 * @since 2020-03-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizComparisonCount {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 比对编号
     */
    private String comparisonCode;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 业务类型（6：月卡车、10：黑名单、25：VIP车辆）
     */
    private Integer bizType;

    /**
     * 通道ID，ice_park_inoutdevice表中的id
     */
    private Long channelId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 平台数据总数
     */
    private Integer platformCount;

    /**
     * 相机数据总数
     */
    private Integer cameraCount;

    /**
     * 对账结果，1：一致 2：不一致
     */
    private Integer result;

    private Date createTime;

}
