package com.icetech.report.domain.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 端云业务数据对比明细
 * </p>
 *
 * @author fangct
 * @since 2020-03-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizComparison {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 比对编号
     */
    private String comparisonCode;

    /**
     * 比对时间
     */
    private Date comparisonTime;

    /**
     * 业务类型（6：月卡车、10：黑名单、25：VIP车辆）
     */
    private Integer bizType;

    /**
     * 通道ID，ice_park_inoutdevice表中的id
     */
    private Long channelId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 车牌号
     */
    private String plateNums;

    /**
     * 对账结果，1：一致 2：不一致
     */
    private Integer result;

    /**
     * 不一致的原因描述
     */
    private String remark;

    private Date createTime;

}
