package com.icetech.park.domain.vo.full;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author wgq
 */
@Data
public class PlateVO {
    /**
     * 车牌颜色序号
     */
    private int color;

    /**
     * 车牌小图大小
     */
    private int clipImgSize;

    /**
     * 特写图，Base64编码后的云存路径
     */
    @JsonProperty("image_path")
    @JSONField(name = "image_path")
    private String imagePath;

    /**
     * 特写图的Base64编码
     */
    private String content;

    /**
     * 车牌 (UTF8)，Base64编码
     */
    private String license;

    /**
     * 车牌宽度
     */
    @JsonProperty("plate_width")
    @JSONField(name = "plate_width")
    private int plateWidth;

    /**
     * 车牌坐标
     */
    private PosVO pos;

    /**
     * 车牌类型
     */
    private int type;

    /**
     * 二值化后的特写图，Base64编码后的云存路径
     */
    @JsonProperty("binimg_path")
    @JSONField(name = "binimg_path")
    private String binimgPath;

    /**
     * 二值化特写图的Base64编码
     */
    @JsonProperty("binimg_content")
    @JSONField(name = "binimg_content")
    private String binimgContent;

    /**
     * 二值化后的车牌小图大小
     */
    private int binimageSize;

    /**
     * 是否是危险车牌（0：否，1：是，-1：功能未开启）
     */
    @JsonProperty("is_danger")
    @JSONField(name = "is_danger")
    private int isDanger;
}
