package com.icetech.park.domain.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wanggang
 * @create 2023-11-27 14:56
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WorkOrderPageVo implements Serializable {

    /**
     * 工单id
     */
    private Long id;

    /**
     * 工单编号
     */
    private String code;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 优先级:1非常紧急;2紧急;3一般
     */
    private Integer priority;

    /**
     * 工单类型:(非常紧急:1系统故障;2:设备故障报修;3:网络通讯故障);(紧急:1软件问题;2:现场安装;3:设备升级和调试);(一般:1计费错误;2:用户培训和指导;3:现场保养;4:远程
     */
    private Integer type;

    /**
     * 用户id:提单人
     */
    private Long userId;

    /**
     * 报单人
     */
    private String userName;

    /**
     * 客服用户 id
     */
    private Long csUserId;

    /**
     * 工单状态:0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer status;

    /**
     * 报单时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date createTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date updateTime;

}
