package com.icetech.park.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wanggang
 * @create 2023-07-31 9:51
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SassShamPlatePageVo implements Serializable {
    /**
     * id
     */
    @ExcelIgnore
    private Long id;

    /**
     * 车场id
     */
    @ExcelIgnore
    private Long parkId;
    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;

    /**
     * 订单号
     */
    @ExcelIgnore
    private String orderNum;

    /**
     * 虚假车牌
     */
    @ExcelProperty(value = "虚假车牌")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @ExcelProperty(value = "车辆类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆")
    private Integer type;

    /**
     * 报警时间
     */
    @ExcelProperty(value = "报警时间")
    private Date alarmTime;

    /**
     * 报警通道名称
     */
    @ExcelProperty(value = "报警通道名称")
    private String channelName;

    /**
     * 关联车牌号
     */
    @ExcelProperty(value = "关联车牌号")
    private String relPlateNum;

    /**
     * 订单状态:1在场;2离场;3已取消;4异常离场
     */
    @ExcelIgnore
    private Integer serviceStatus;

    /**
     * 是否有子订单，0：否，1：是，默认为0
     */
    @ExcelIgnore
    private Integer hasSon;

}
