package com.icetech.park.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.Data;

import java.math.BigDecimal;

/**
 * Description ParkRecoverySettleVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/27 15:24
 */
@Data
public class ParkRecoverySettleVo {

    @ExcelIgnore
    private Integer id;

    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;

    /**
     * 机构名称
     */
    @ExcelProperty(value = "所属机构")
    private String institutionName;

    /**
     * 车场id
     */
    @ExcelIgnore
    private Long parkId;

    /**
     * 所属机构
     */
    @ExcelIgnore
    private Integer institutionId;

    /**
     * 月份
     */
    @ExcelProperty(value = "结算月份")
    private String settleMonth;

    /**
     * 追缴金额
     */
    @ExcelProperty(value = "追缴金额")
    private BigDecimal recoveryMoney;

    /**
     * 佣金
     */
    @ExcelProperty(value = "佣金（10%）")
    private BigDecimal commission;

    /**
     * 订单号
     */
    @ExcelIgnore
    private String orderNum;
    
    /**
     * 支付方式，1-微信，2-支付宝
     */
    @ExcelProperty(value = "支付方式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=微信,2=支付宝")
    private Integer payMethod;

    /**
     * 渠道订单号
     */
    @ExcelProperty(value = "渠道订单号")
    private String channelOrderNo;

    /**
     * 支付状态，0-未支付，1-已支付
     */
    @ExcelProperty(value = "佣金支付", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=未支付,1=已支付")
    private Integer payStatus;

    /**
     * 1-有效
     */
    @ExcelIgnore
    private Integer status;
}
