package com.icetech.park.domain.vo;

import com.icetech.common.domain.Page;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Description ParkTrusteeshipRecordPage
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/4 09:56
 */
@Data
public class ParkRecoverySettlePage<T> extends Page<T> implements Serializable {

    /**
     * 总的追缴金额
     */
    private BigDecimal totalRecoveryMoney;

    /**
     * 总的佣金
     */
    private BigDecimal totalCommission;

    public static <T> ParkRecoverySettlePage<T> instance(int totalPage, long total, List<T> row) {
        ParkRecoverySettlePage<T> page = new ParkRecoverySettlePage<>();
        page.setTotalPage(totalPage);
        page.setTotal(total);
        page.setRows(row);
        return page;
    }
    
    
}
