package com.icetech.park.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description ParkRecoveryApplyVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/24 10:18
 */
@Data
public class ParkRecoveryApplyVo extends ParkRecoveryApplyBaseVo implements Serializable {

    /**
     * 支付方式，1-微信，2-支付宝
     */
    @ExcelProperty(value = "支付方式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=微信,2=支付宝")
    private Integer payMethod;

    /**
     * 付费模式,1-溢价模式，2-固定收费模式，3-合作分成模式
     */
    @ExcelProperty(value = "付费模式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=溢价模式,2=固定收费模式,3=合作分成模式")
    private Integer payModel;

    /**
     * 渠道订单号
     */
    @ExcelProperty(value = "渠道订单号")
    private String channelOrderNo;

    /**
     * 服务费用
     */
    @ExcelProperty(value = "月租服务费")
    private BigDecimal serviceCharge;

    /**
     * 分账协议地址， 逗号分割
     */
    @ExcelIgnore
    private String divisionContract;

    /**
     * 分账协议地址，全路径 逗号分割
     */
    @ExcelIgnore
    private String divisionContractFull;
}
