package com.icetech.park.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description ParkRecoveryApplyBaseVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/8/29 14:54
 */
@Data
public class ParkRecoveryApplyBaseVo implements Serializable {

    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;

    /**
     * 机构名称
     */
    @ExcelProperty(value = "所属机构")
    private String institutionName;

    /**
     * 所属一级机构名称
     */
    @ExcelProperty(value = "所属一级机构")
    private String institution1Name;


    /**
     * 主键自增长id
     */
    @ExcelIgnore
    private Integer id;

    /**
     * 车场id
     */
    @ExcelIgnore
    private Long parkId;

    /**
     * 所属机构
     */
    @ExcelIgnore
    private Integer institutionId;

    /**
     * 申请订单号
     */
    @ExcelIgnore
    private String orderNum;

    /**
     * 申请类型：1-试用，2-开通
     */
    @ExcelProperty(value = "试用/开通", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=试用,2=申请开通")
    private Integer applyType;

    /**
     * 开通状态，0-未开通，1-已开通
     */
    @ExcelIgnore
    private Integer openStatus;

    /**
     * 记录状态 ,1=未生效,2=生效中,3=已完成
     */
    @ExcelProperty(value = "状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=未生效,2=生效中,3=已完成")
    private Integer recordStatus;

    /**
     * 申请人
     */
    @ExcelProperty(value = "申请人")
    private String applicant;

    /**
     * 联系人
     */
    @ExcelIgnore
    private String contacts;

    /**
     * 联系电话
     */
    @ExcelProperty(value = "联系电话")
    private String contactsNumber;

    /**
     * 申请时间
     */
    @ExcelProperty(value = "申请时间")
    private Date applyTime;


    /**
     * 开始时间
     */
    @ExcelProperty(value = "开始时间")
    private String startTime;

    /**
     * 结束时间
     */
    @ExcelProperty(value = "结束时间")
    private String endTime;

    /**
     * 开通时间
     */
    @ExcelProperty(value = "开通时间")
    private Date openTime;

    /**
     * 开通人
     */
    @ExcelProperty(value = "开通人")
    private String openBy;

    /**
     * 创建时间
     */
    @ExcelIgnore
    private Date createTime;

    /**
     * 更新时间
     */
    @ExcelIgnore
    private Date updateTime;

    /**
     * 操作人
     */
    @ExcelIgnore
    private String operator;
}
