package com.icetech.park.domain.vo;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.util.List;

/**
 * 优惠查询条件
 */
@Data
public class FindDiscountVo {
    /**
     * 商户ID
     */
    @NotNull
    private Long merchantId;

    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 开始时间
     */
    @NotNull
    private String from;
    /**
     * 结束时间
     */
    @NotNull
    private String to;
    /**
     * 优惠类型,1全免、2减免时间、3减免金额、4折扣、5按天优免
     */
    private List<Integer> discountTypeList;

    /**
     * 状态
     */
    private Integer status;
    private Integer pageSize = 10;
    private Integer pageNo = 1;
}
