package com.icetech.park.domain.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 查看视频信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EvidenceVideoVO implements Serializable {
    /**
     * 是否开通欠费追缴服务,0:未开通,1:已开通
     */
    private Integer isOpenRecovery;
    /**
     * 是否加装监控相机，0：未装，1：已装
     */
    private Integer hasMorCamera;
    /**
     * 视频是否过期，0：未过期，1：已过期
     */
    private Integer videoExpire;
    /**
     * 欠费追缴服务过期天数
     */
    private Integer timeOutDays;
    /**
     * 视频地址
     */
    private String videoUrl;
    private String channelName;
    private String plateNum;
}
