package com.icetech.park.domain.request.sms;

import java.time.LocalDateTime;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString(callSuper = true)
public class SmsAlarmOrderParam extends SmsAlarmOrder {
    /** 车场ID列表 */
    protected Set<Long> parkIds;
    protected Set<Long> permitParkIds;
    /** 车场数据采集方式 */
    protected Integer parkDataCollection;
    /** 订单号(模糊搜索) */
    protected String orderNumPart;
    /** 创建人(模糊搜索) */
    protected String createUserPart;
    /** 支付方式(0-现金;1-银行卡;2-微信;3-支付宝) */
    protected Set<Integer> payMethods;
    /** 最小购买时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime minPayTime;
    /** 最大购买时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime maxPayTime;

    /** 当前页数 */
    protected Integer pageNo = 1;
    /** 当前页数 */
    protected Integer pageIndex = 1;
    /** 分页条数 */
    protected Integer pageSize = 10;

    public void setPageNo(Integer pageNo) {
        setPageIndex(pageNo);
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageNo = pageIndex;
        this.pageIndex = pageIndex;
    }
}
