package com.icetech.park.domain.request.sms;

import java.util.Set;

import com.icetech.park.domain.entity.sms.SmsAlarmOperRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString(callSuper = true)
public class SmsAlarmOperRecordParam extends SmsAlarmOperRecord {
    /** 车场ID列表 */
    protected Set<Long> parkIds;
    protected Set<Long> permitParkIds;
    /** 操作模块 */
    protected Set<Integer> moduleTypes;

    /** 当前页数 */
    protected Integer pageNo = 1;
    /** 当前页数 */
    protected Integer pageIndex = 1;
    /** 分页条数 */
    protected Integer pageSize = 10;

    public void setPageNo(Integer pageNo) {
        setPageIndex(pageNo);
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageNo = pageIndex;
        this.pageIndex = pageIndex;
    }
}
