package com.icetech.park.domain.request.month;

import lombok.Data;

import java.util.List;

@Data
public class DepositParam {

    /**
     * 车场ID
     */
    private List<Long> parkIds;

    /**
     * 车牌
     */
    private String plateNum;

    /**
     * 押金状态
     * 0-未退，10-已退，2-退返失败
     */
    private Integer depositStatus;

    /**
     * 办理月卡时间
     */
    private Long startHandTime;

    /**
     * 办理月卡时间
     */
    private Long  endHandTime;

    /**
     * 操作开始时间
     */
    private Long startOperateTime;

    /**
     * 操作结束时间
     */
    private Long endOperateTime;

    /**
     * 审核结果 0-审核不通过，1-审核通过，2待审核
     */
    private Integer auditResult;

    /**
     * 页码
     */
    private Integer pageNo = 1;

    /**
     * 分页大小
     */
    private Integer pageSize = 10;
}
