package com.icetech.park.domain.request;

import lombok.Data;

import java.io.Serializable;

/**
 * Description WorkOrderCreateParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/29 17:09
 */
@Data
public class WorkOrderCreateParam implements Serializable {

    /**
     * 工单 id，编辑时必传
     */
    private Long workOrderId;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 优先级:1非常紧急;2紧急;3一般
     */
    private Integer priority;

    /**
     * 工单类型:(非常紧急:1系统故障;2:设备故障报修;3:网络通讯故障);(紧急:1软件问题;2:现场安装;3:设备升级和调试);(一般:1计费错误;2:用户培训和指导;3:现场保养;4:远程)
     */
    private Integer type;

    /**
     * 故障设备类型:1:识别相机;2道闸:3对讲设备;4监控相机;5:一体机
     */
    private Integer deviceType;

    /**
     * 软件问题选项:停车云平台;车场帮APP;知位岗亭;场内/出口扫码支付;智慧停车云坐席;车场监控;知位车主公众号;知位优免小程序
     */
    private String softwareOption;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 设备型号
     */
    private String productModel;

    /**
     * 设备序列号
     */
    private String serialNumber;
    
    /**
     * 设备版本
     */
    private String deviceVersion;
    
    /**
     * 联系电话
     */
    private String phone;

    /**
     * 服务请求
     */
    private String remark;

    /**
     * 图片地址
     */
    private String imageUrl;

    /**
     * 视频地址
     */
    private String videoUrl;
}
