package com.icetech.park.domain.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class RefundParam {

    /**
     * 道路id
     */
    private List<Long> parkIds;

    /**
     * 车牌
     */
    private String plateNum;

    /**
     * 业务号
     */
    private String orderNum;

    /**
     * 车辆类型:1临时车2月卡车3特殊车辆
     */
    private Integer carType;

    /**
     * 退款状态  1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    private Integer refundStatus;

    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date startDate;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDate;
    /**
     * 页码
     */
    private Integer pageNo = 1;
    /**
     * 分页大小
     */
    private Integer pageSize = 10;
}
