package com.icetech.park.domain.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description ParkRecoveryOpenParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/24 15:40
 */
@Data
public class ParkRecoverySettlePayParam implements Serializable {
    
    /**
     * 结算 id
     */
    @NotNull(message = "结算id不能为空")
    @ApiModelProperty(value = "结算id", example = "1", required = true, position = 1)
    private Long recoverySettleId;

    /**
     * 跳转的 url
     */
    private String returnUrl;
    
}
