package com.icetech.park.domain.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description ParkRecoveryApplyQuery
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/24 10:15
 */
@Data
public class ParkRecoveryApplyQuery implements Serializable {

    /**
     * 车场id
     */
    private List<Long> parkId;

    /**
     * 所属机构
     */
    private List<Integer> institutionId;

    /**
     * 申请类型：1-试用，2-开通
     */
    private List<Integer> applyType;

    /**
     * 记录状态 ,1=未生效,2=生效中,3=已完成
     */
    private List<Integer> recordStatus;

    /**
     * 开通开始时间
     */
    private String openStartTime;

    /**
     * 开通结束时间
     */
    private String openEndTime;

    /**
     * 页码
     */
    private Integer pageNo;
    
    /**
     * 分页大小
     */
    private Integer pageSize;
}
