package com.icetech.park.domain.request;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderRefundParam {

    private Long id;

    /**
     * 订单编号
     */
    private String orderNum;

    private List<Long> parkIds;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 更新人
     */
    private String userName;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 退款状态 -1=已取消 0= 待审核 1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    private Integer refundStatus;

    /**
     * 取消退款原因
     */
    private String refundReason;
}
