package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_template`")
public class SmsAlarmTemplate implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 模板类型(1-设备离线;2-月卡临期;3-VIP临期;4-中心服务离线;5-计费软件离线;) */
    @TableField(value = "`type`")
    protected Integer type;
    /** 模板名称 */
    @TableField(value = "`name`")
    protected String name;
    /** 模板内容 */
    @TableField(value = "`content`")
    protected String content;
    /** 模板ID */
    @TableField(value = "`template_code`")
    protected String templateCode;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`create_time`")
    protected LocalDateTime createTime;
    /** 更新时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`update_time`")
    protected LocalDateTime updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
}
