package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_send_record`")
public class SmsAlarmSendRecord implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 短信类型(1-设备离线通知;2-月卡临期通知;3-VIP临期通知;4-中心服务故障;5-岗亭计费软件故障) */
    @TableField(value = "`sms_type`")
    protected Integer smsType;
    /** 收信手机号 */
    @TableField(value = "`recv_phone`")
    protected String recvPhone;
    /** 短信内容 */
    @TableField(value = "`sms_content`")
    protected String smsContent;
    /** 短信条数 */
    @TableField(value = "`sms_count`")
    protected Integer smsCount;
    /** 发送编号 */
    @TableField(value = "`send_no`")
    protected String sendNo;
    /** 发送序号 */
    @TableField(value = "`send_seq`")
    protected Integer sendSeq;
    /** 关联数据ID */
    @TableField(value = "`ref_data_id`")
    protected String refDataId;
    /** 车牌号 */
    @TableField(value = "`plate_nums`")
    protected String plateNums;
    /**
     * 设备类型
     * @see com.icetech.basics.domain.entity.device.ParkDevice#type
     */
    @TableField(value = "`device_type`")
    protected Integer deviceType;
    /** 通道ID */
    @TableField(value = "`channel_id`")
    protected Integer channelId;
    /** 发送时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`send_time`")
    protected LocalDateTime sendTime;
    @TableField(value = "`remark`")
    protected String remark;
}
