package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class SmsAlarmRuleBase implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`create_time`", updateStrategy = FieldStrategy.NEVER)
    protected LocalDateTime createTime;
    /** 更新时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`update_time`")
    protected LocalDateTime updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
}
