package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_oper_record`")
public class SmsAlarmOperRecord implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 操作模块(1-设备离线;2-月卡临期提醒;3-VIP临期提醒;4-本地中心离线;5-本地计费离线) */
    @TableField(value = "`module_type`")
    protected Integer moduleType;
    /** 操作类型(1-状态变更) */
    @TableField(value = "`oper_type`")
    protected Integer operType;
    /** 操作值 */
    @TableField(value = "`oper_val`")
    protected Integer operVal;
    /** 操作时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`oper_time`")
    protected LocalDateTime operTime;
    /** 操作人 */
    @TableField(value = "`oper_user`")
    protected String operUser;
}
