package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_config`")
public class SmsAlarmConfig implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 短信总数量 */
    @TableField(value = "`total_count`")
    protected Integer totalCount;
    /** 使用数量 */
    @TableField(value = "`used_count`")
    protected Integer usedCount;
    /** 剩余数量 */
    @TableField(value = "`curr_count`")
    protected Integer currCount;
    /** 设备离线提醒开关(0-关闭;1-开启) */
    @TableField(value = "`device_enable_flag`")
    protected Integer deviceEnableFlag;
    /** 月卡临期提醒开关(0-关闭;1-开启) */
    @TableField(value = "`month_enable_flag`")
    protected Integer monthEnableFlag;
    /** VIP临期提醒开关(0-关闭;1-开启) */
    @TableField(value = "`vip_enable_flag`")
    protected Integer vipEnableFlag;
    /** 本地中心离线提醒开关(0-关闭;1-开启) */
    @TableField(value = "`pnc_center_enable_flag`")
    protected Integer pncCenterEnableFlag;
    /** 本地中心离线提醒开关(0-关闭;1-开启) */
    @TableField(value = "`pnc_charge_enable_flag`")
    protected Integer pncChargeEnableFlag;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`create_time`")
    protected LocalDateTime createTime;
    /** 更新时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`update_time`")
    protected LocalDateTime updateTime;

    public int getTotalCountVal() {
        return totalCount == null ? 0 : totalCount;
    }

    public Integer getUsedCountVal() {
        return usedCount == null ? 0 : usedCount;
    }

    public Integer getCurrCountVal() {
        return currCount == null ? 0 : currCount;
    }

    public SmsAlarmConfig addTotalCount(int count) {
        totalCount = getTotalCountVal() + count;
        return this;
    }

    public SmsAlarmConfig calcCurrCount() {
        currCount = getTotalCountVal() - getUsedCountVal();
        if (currCount < 0) currCount = 0;
        return this;
    }
}
