package com.icetech.park.domain.entity.park;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 车场欠费追缴申请记录
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_recovery_apply")
public class ParkRecoveryApply implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 所属机构
     */
    private Integer institutionId;    
    
    /**
     * 所属机构一级机构
     */
    private Integer institution1Id;

    /**
     * 申请订单号
     */
    private String orderNum;

    /**
     * 申请类型：1-试用，2-开通
     */
    private Integer applyType;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String contactsNumber;

    /**
     * 申请人
     */
    private String applicant;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 开通状态，0-未开通，1-已开通
     */
    private Integer openStatus;

    /**
     * 支付方式，1-微信，2-支付宝
     */
    private Integer payMethod;

    /**
     * 渠道订单号
     */
    private String channelOrderNo;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 开通人
     */
    private String openBy;

    /**
     * 开通时间
     */
    private Date openTime;

    /**
     * 付费模式,1-溢价模式，2-固定收费模式，3-合作分成模式
     */
    private Integer payModel;

    /**
     * 服务费用
     */
    private BigDecimal serviceCharge;

    /**
     * 状态，1-有效
     */
    private Integer status;
    
    /**
     * 支付人
     */
    private String payerName;

    /**
     * 合作分成模式的平台分账比例
     */
    private BigDecimal divisionProfit;

    /**
     * 合作分成模式的车场出账方商户编号
     */
    private String parkMchNo;

    /**
     * 合作分成模式的平台入账方收款商户编号
     */
    private String platformMchNo;

    /**
     * 合作分成模式的分账规则编号
     */
    private String groupId;

    /**
     * 分账协议地址
     */
    private String divisionContract;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;


}
