package com.icetech.park.domain.entity.month;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 月卡押金操作记录表
 * Description : 记录月卡押金相关操作（新增、续费、修改、退卡等）
 */
@Data
@TableName(value = "`ice_month_deposit_operate_record`")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MonthDepositOperateRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    private Integer id;

    /**
     * 押金记录
     */
    @TableField(value = "`deposit_id`")
    private Integer depositId;

    /**
     * 操作类型1 新增 2 续费 3 修改 4 退卡
     */
    @TableField(value = "`card_opertype`")
    private Integer cardOpertype;


    /**
     * 押金退返状态(0-退返失败，1-退返成功，2-退款中）
     */
    @TableField(value = "`deposit_status`")
    private Integer depositStatus;

    /**
     * 押金退返时间
     */
    @TableField(value = "`deposit_time`")
    private Date depositTime;

    /**
     * 备注
     */
    @TableField(value = "`remark`")
    private String remark;

    /**
     * 审核原因
     */
    @TableField(value = "`audit_reason`")
    private String auditReason;

    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;

    /**
     * 审核结果 0-审核不通过，1-审核通过，2待审核
     */
    @TableField(value = "`audit_result`")
    private Integer auditResult;

    /**
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    @TableField(value = "`pay_channel`")
    private Integer payChannel;

    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;

}