package com.icetech.park.domain.entity.led;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_led_sound`")
public class LedSound implements Serializable {
    /** 主健自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Long channelId;
    /** 语音类型 1：入场临时车、2：入场月卡车/内部车辆、3：入场无牌车、 4、车位已满5：出场收费车辆、6：出场支付成功、7：出场月卡车、8：出场无牌车、9：免费车辆（临时/特殊）、10.出场差无入场记录、11：临时车禁止通行、12：多位多车车位占用、13黑名单车辆进出场 、14入场储值卡车、15入口欠费补缴16出口补缴、17虚假车牌 */
    @TableField(value = "`sound_type`")
    protected Integer soundType;
    /** 动态内容编号和播放序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：需支付金额、9.一路平安、10.欢迎光临11请等待人工确认（比如：”4_1+5_3”,动态内容需要播放车牌号和车辆类型，车牌号排第一播放，车辆类型排第三播放） */
    @TableField(value = "`dynamic_content`")
    protected String dynamicContent;
    /** 自定义内容和播放序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一车一杆_2+注意安全_4”,自定义内容中一路平安排第二播放，注意安全排第四播放) */
    @TableField(value = "`custom_content`")
    protected String customContent;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;

    public enum SoundTypeEnum {
        入场临时车(1), 入场月卡车_内部车辆(2), 入场无牌车(3), 车位已满(4),
        出场收费车辆(5), 出场支付成功(6), 出场月卡车(7), 出场无牌车(8),
        出场免费车辆_临时特殊(9), 出场无入场记录(10), 临时车禁止通行(11), 多位多车车位占用(12),
        黑名单车辆进出场(13),入口欠费补缴(15), 出口欠费补缴(16), 入口虚假车牌(17), 出口虚假车牌(18)
                ;
        public int type;
        private SoundTypeEnum(int type){
            this.type = type;
        }
    }
    public enum VariateEnum {
        当前时间(1), 今日限号(2), 剩余车位(3), 车牌号(4),
        车辆类型(5), 月卡剩余天数(6), 停车时长(7), 需支付金额(8),
        一路平安(9), 欢迎光临(10), 请等待人工确认(11),
        ;
        public int type;
        private VariateEnum(int type){
            this.type = type;
        }
    }
}
