package com.icetech.park.domain.entity.lcd;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_lcd_soundcode`")
public class LcdSoundcode implements Serializable {
    private static final long serialVersionUID = 1L;
    /** 主键自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 语音编号 */
    @TableField(value = "`sound_code`")
    protected String soundCode;
    /** 语音内容 */
    @TableField(value = "`content`")
    protected String content;
    /** 按动静态分类，1：静态，2：动态 */
    @TableField(value = "`type`")
    protected Integer type;
    /** 是否自定义语音，1：是，0：否 */
    @TableField(value = "`is_custom`")
    protected Integer isCustom;
    /** 定制语音文件地址 */
    @TableField(value = "`custom_sound_path`")
    protected String customSoundPath;
    /** 创建时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
}
