package com.icetech.park.domain.entity.lcd;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_lcd_sound`")
public class LcdSound implements Serializable {
    /** 主键自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Long channelId;
    /** 按播放场景分类，1：入场临时车/特殊车、2：入场月卡车/内部车辆、3：入场无牌车、 4、车位已满5：出场收费车辆、6：出场支付成功、7：出场月卡车、8：出场无牌车、9：免费车辆（临时/特殊）、10.出场无入场记录、11：临时车禁止通行、12：多位多车车位占用、13黑名单车辆进出场 14、入场储值卡15入口欠费补缴16出口补缴、17虚假车牌 */
    @TableField(value = "`sound_type`")
    protected Integer soundType;
    /** 语音内容模板，多个语音编号之间用"+"连接，语音编号查看ice_lcd_soundcode表（比如："D3+D4”,需要按先后顺序播放车牌号和车辆类型，车牌号先播放，车辆类型后播放） */
    @TableField(value = "`content_pattern`")
    protected String contentPattern;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;

    public enum SoundTypeEnum {
        入场临时车(1), 入场月卡车_内部车辆(2), 入场无牌车(3), 车位已满(4),
        出场收费车辆(5), 出场支付成功(6), 出场月卡车(7), 出场无牌车(8),
        出场免费车辆_临时特殊(9), 出场无入场记录(10), 临时车禁止通行(11), 多位多车车位占用(12),
        黑名单车辆进出场(13),入场储值卡车(14), 入口欠费补缴(15), 出口欠费补缴(16), 入口虚假车牌(17), 出口虚假车牌(18)
        ;
        public int type;
        private SoundTypeEnum(int type){
            this.type = type;
        }
    }

}
