package com.icetech.park.domain.entity.lcd;

import java.io.Serializable;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_lcd_config`")
public class LcdConfig implements Serializable {
    /** 主键自增 */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Long channelId;
    /** 显示屏行数（目前只支持2、3和4），默认是2 */
    @TableField(value = "`line_num`")
    protected Integer lineNum;
    /** 月卡剩余多少天进行提示，默认是0,表示不受限制 */
    @TableField(value = "`remain_days_mc`")
    protected Integer remainDaysMc;
    /** 月卡过期小于多少天进行提示，默认是0,表示不受限制 */
    @TableField(value = "`expire_days_mc`")
    protected Integer expireDaysMc;
    /** 过期卡车辆按月卡车处理,1是0否 */
    @TableField(value = "`expire_days_month`")
    protected Integer expireDaysMonth;
    /** 黑名单车辆信息是否提示，0提示，1不提示，默认为0 */
    @TableField(value = "`black_car`")
    protected Integer blackCar;
    /** 入口空闲显示布局 */
    @TableField(value = "`entrance_free_layout`")
    protected Integer entranceFreeLayout;
    /** 入口显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告 */
    @TableField(value = "`enter_layout`")
    protected Integer enterLayout;
    /** 出口空闲显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告 */
    @TableField(value = "`exit_free_layout`")
    protected Integer exitFreeLayout;
    /** 出场显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告 */
    @TableField(value = "`exit_layout`")
    protected Integer exitLayout;
    /** 恢复默认显示时长，单位是秒，默认是90s */
    @TableField(value = "`restore_default_time`")
    protected Integer restoreDefaultTime;
    /** 音量配置，音量值范围1~10，默认为10 */
    @TableField(value = "`volume_value`")
    protected Integer volumeValue;
    /** 勿扰模式是否开启，0不开启，1开启，默认为0 */
    @TableField(value = "`quiet_hours_switch`")
    protected Integer quietHoursSwitch;
    /** 勿扰模式开始时间 */
    @TableField(value = "`quiet_start_time`")
    protected LocalTime quietStartTime;
    /** 勿扰模式结束时间 */
    @TableField(value = "`quiet_end_time`")
    protected LocalTime quietEndTime;
    /** 勿扰模式音量音量值范围1~10，默认为1 */
    @TableField(value = "`quiet_volume_value`")
    protected Integer quietVolumeValue;
    /** 限行类型：0是尾号限行，1是单双号限行，默认为0 */
    @TableField(value = "`limit_type`")
    protected Integer limitType;
    /** 周一限行信息，尾号限行填写比如：4和9，单双号限行不填写 */
    @TableField(value = "`limit_drive_num1`")
    protected String limitDriveNum1;
    /** 周二限行信息，尾号限行填写比如：5和0，单双号限行不填写 */
    @TableField(value = "`limit_drive_num2`")
    protected String limitDriveNum2;
    /** 周三限行信息，尾号限行填写：1和6，单双号限行不填写 */
    @TableField(value = "`limit_drive_num3`")
    protected String limitDriveNum3;
    /** 周四限行信息，尾号限行填写：2和7，单双号限行不填写 */
    @TableField(value = "`limit_drive_num4`")
    protected String limitDriveNum4;
    /** 周五限行信息，尾号限行填写：3和8，单双号限行不填写 */
    @TableField(value = "`limit_drive_num5`")
    protected String limitDriveNum5;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    @TableField(value = "`region_free_space`")
    protected Long regionFreeSpace;

    @TableField(exist = false)
    private List<LcdBrightness> lcdBrightnessList;

    public static final DateTimeFormatter QUIET_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    public String formatQuietStartTime() {
        return quietStartTime == null ? null : quietStartTime.format(QUIET_TIME_FORMATTER);
    }

    public String formatQuietEndTime() {
        return quietEndTime == null ? null : quietEndTime.format(QUIET_TIME_FORMATTER);
    }
}
