package com.icetech.park.domain.entity.invoice;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 发票-发票与交易关联表
 * @author fangct
 */
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class InvoiceBlue  implements Serializable {
    private Integer id;
    /**
     * 发票配置ID
     * {@link InvoiceMerchant#getId()}
     */
    private Integer merchantId;
    /** 开票订单号 */
    private String orderId;
    /** 第三方接口id */
    private String thirdId;
    /** 开票方纳税人识别号(15~20位数字或者大写字母) */
    private String taxpayerNum;
    /** 发票抬头类型, 1:个人/事业单位 ,2:企业, */
    private Integer buyerTitleType;
    /** 购货方识别号（当开票抬头类型为 2时：必填） */
    private String buyerTaxcode;
    /** 购方名称 */
    private String buyerTitle;
    /** 接收邮箱地址 */
    private String buyerEmail;
    /** 发票状态（1开票中,2开票成功 -2开票失败） */
    private Integer status;
    /** png发票存储地址 */
    private String imgPath;
    /** pdf发票存储地址 */
    private String pdfPath;
    /** 发票pdf的url地址 */
    private String pdfUrl;
    /** 发票号码 */
    private String ticketSn;
    /** 发票代码 */
    private String ticketCode;
    /** 开票时间 */
    private String ticketDate;
    /** 发票的金额 */
    private String fee;
    /** 不含税金额 */
    private String feeWithoutTax;
    /** 税额 */
    private String tax;
    /** 发票校验码 */
    private String checkCode;
    /** 插卡状态  (3插卡成功,-3插卡失败) */
    private String cardStatus;
    /** 卡券code */
    private String cardCode;
    /** 用户openid */
    private String openid;
    /** 公众号登陆用户id */
    private Integer mpUserId;
    /** 开票通道 1= 高灯 2= 票通 */
    private Integer channel;
    /** 提交时间 */
    private Date createTime;
    /** 开票时间 */
    private Date updateTime;
    /** 备注 */
    private String remark;
    /** 发票来源 1=场库停车费 2=服务费 3=路内停车费 */
    private Integer source;
    /** 多个车牌号 */
    private String plateNums;
    /**  */
    private Long parkId;


    /** 购买方银行名称 */
    private String bankName;
    /** 购买方银行账号 */
    private String bankAccount;
    /** 购买方地址 */
    private String buyerAddress;
    /** 购买方电话 */
    private String buyerPhone;
    /** 发票备注 */
    private String invoiceRemark;
}
