package com.icetech.park.domain.entity.catched;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Auther: fangct
 * @Date: 2018/12/18
 * @Description: 用户上次填写发票信息的缓存记录表
 */
@TableName("ice_invoice_usercache")
@Data
public class InvoiceUsercache implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长
     */
    @TableId(value = "id",type= IdType.AUTO )
    private Long id;
    /**
     * 用户统一唯一标识
     */
    private String unionId;
    /**
     * 税号
     */
    private String buyerTaxcode;
    /**
     * 邮箱地址
     */
    private String buyerEmail;
    /**
     * 抬头名称
     */
    private String buyerTitle;
    /**
     * 开票类型，1:个人，2单位
     */
    private Integer buyerTitleType;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

}
