package com.icetech.park.domain.entity.car;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 盘点车辆清理表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-08-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_car_clean")
@AllArgsConstructor
@Builder
public class CarClean implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 批次号
     */
    private String batchCode;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * 车辆类型:1临时车;2月卡车;3特殊车辆;4VIP车辆;5访客车辆;6储值卡车
     */
    private Integer carType;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 入场图片
     */
    private String enterImage;

    /**
     * 清理方式:1车辆盘点;2系统自动清理;3在场车辆批量删除
     */
    private Integer type;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 删除标志:0未删除;1已删除
     */
    private Integer deleted;


}
