package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 工单表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_work_order")
@AllArgsConstructor
@Builder
public class WorkOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 工单编号
     */
    private String code;

    /**
     * 优先级:1非常紧急;2紧急;3一般
     */
    private Integer priority;

    /**
     * 工单类型:(非常紧急:11系统故障;12:设备故障报修;13:网络通讯故障);(紧急:21软件问题;22:现场安装;23:设备升级和调试);(一般:31计费错误;32:用户培训和指导;33:现场保养;34:远程)
     */
    private Integer type;

    /**
     * 故障设备类型:1:识别相机;2道闸:3对讲设备;4监控相机;5:一体机
     */
    private Integer deviceType;

    /**
     * 软件问题选项:停车云平台;车场帮APP;知位岗亭;场内/出口扫码支付;智慧停车云坐席;车场监控;知位车主公众号;知位优免小程序
     */
    private String softwareOption;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 设备型号
     */
    private String productModel;

    /**
     * 设备序列号
     */
    private String serialNumber;

    /**
     * 设备版本
     */
    private String deviceVersion;

    /**
     * 用户id:提单人
     */
    private Long userId;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 客服用户 id
     */
    private Long csUserId;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 服务请求
     */
    private String remark;

    /**
     * 图片地址
     */
    private String imageUrl;

    /**
     * 视频地址
     */
    private String videoUrl;

    /**
     * 工单状态:0;待处理;1处理中;2已完成;3已取消;4:已退单
     */
    private Integer status;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
