package com.icetech.park.domain.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 本地平台对账明细表
 * </p>
 *
 * @author fangct
 * @since 2019-08-03
 */
@Data
public class ReconciliationInfo {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 账单日期
     */
    private String reportDate;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 订单号
     */
    private String orderNum;
    private String LocalOrderNum;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 本地账单应收
     */
    private BigDecimal localPriceTotal;

    /**
     * 本地账单实收
     */
    private BigDecimal localPricePaid;

    /**
     * 本地账单优惠
     */
    private BigDecimal localPriceDiscount;

    /**
     * 本地账单实际收钞
     */
    private BigDecimal localActualCash;

    /**
     * 本地账单红包找零
     */
    private BigDecimal localRedpackRet;

    /**
     * 缴费渠道1本地出口支付,2 H5扫码支付,3自助缴费机,4中央收费站,5第三方,6云岗亭小程序,7免密支付,8停车机器人,9公众号缴费
     */
    private Integer payChannel;

    /**
     * 缴费方式1现金，2微信，3支付宝，4银联
     */
    private Integer payWay;

    /**
     * 支付时间
     */
    private Integer payTime;

    /**
     * 平台账单应收
     */
    private BigDecimal platformPriceTotal;

    /**
     * 平台账单实收
     */
    private BigDecimal platformPricePaid;

    /**
     * 平台账单优惠
     */
    private BigDecimal platformPriceDiscount;

    /**
     * 平台账单实际收钞
     */
    private BigDecimal platformActualCash;

    /**
     * 平台账单红包找零
     */
    private BigDecimal platformRedpackRet;

    /**
     * 对账结果，1：对账一致2：对账不一致3：平台有本地无 4：本地有平台无
     */
    private Integer result;

    private Date createTime;

    private Date updateTime;


}
