package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 访客车辆用户次数表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_visituser")
@AllArgsConstructor
@Builder
public class ParkVisituser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 月最大可添加访客次数 默认100
     */
    private Integer monthMaxNum;

    /**
     * 预约时间最大范围（天数）
     */
    private Integer monthMaxDay;

    /**
     * 访客预约总次数
     */
    private Integer allNum;

    /**
     * 已发送次数
     */
    private Integer sendNums;

    /**
     * 剩余次数
     */
    private Integer nowNums;

    /**
     * 操作时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String updateUser;


}
