package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 车场托管
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_trusteeship")
public class ParkTrusteeship implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 通道数量
     */
    private Integer channelNum;

    /**
     * 托管模式：1-甲方自建坐席托管，2-知位自营坐席托管
     */
    private Integer trusteeshipModel;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 云坐席sip号
     */
    private String sipNum;

    /**
     * 是否开通延期提醒
     */
    private Integer openWarn;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 临近到期提醒天数
     */
    private Integer nearExpireDay;

    /**
     * 过期提醒天数
     */
    private Integer expireDay;

    /**
     * 1-有效
     */
    private Integer status;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;


}
