package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 固件升级任务表
 * </p>
 *
 * @author fangct
 * @since 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_firmware_upgrade")
public class FirmwareUpgrade extends Model<FirmwareUpgrade> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 设备类型, 1：识别相机
     */
    private Integer deviceType;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 设备序列号
     */
    private String sn;

    /**
     * 设备型号
     */
    private String productModel;

    /**
     * 文件包ID
     */
    private Long fileId;

    /**
     * 原始版本号
     */
    private String sourceVer;

    /**
     * 目标版本号
     */
    private String targetVer;

    /**
     * 升级执行时间
     */
    private Date actionTime;

    /**
     * 升级成功时间
     */
    private Date successTime;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 升级状态，1：待升级，2：升级中，3：升级成功，4：升级失败
     */
    private Integer status;

    /**
     * 操作人账号
     */
    private String operAccount;

    /**
     * 升级渠道,1: web，2:ops
     */
    private Integer upgradeChannel;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public enum StatusEnum {
        待升级(1), 升级中(2), 升级成功(3), 升级失败(4);
        public int status;
        StatusEnum(int status){
            this.status = status;
        }
    }
}
