package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 固件表
 * </p>
 *
 * @author fangct
 * @since 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_firmware")
public class Firmware extends Model<Firmware> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 固件版本号
     */
    private String firmwareVersion;

    /**
     * 固件型号ID
     */
    private Integer productModelId;

    /**
     * 固件包文件ID
     */
    private Integer fileId;

    /**
     * 删除标识, 0：正常，1：删除
     */
    private Boolean delFlag;

    /**
     * 操作人账号
     */
    private String operAccount;

    /**
     * 添加时间
     */
    private Date createTime;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
