package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 批量下发子主任务表
 * </p>
 *
 * @author fangct
 * @since 2021-02-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_batchsend_task_sub")
public class BatchsendTaskSub extends Model<BatchsendTaskSub> {

    private static final long serialVersionUID = 1L;

    /**
     * 子任务id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 主任务ID
     */
    private String taskId;

    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 多个业务类型,用逗号隔开, 101：高级配置，102：通道信息 ，103：计费规则，104：屏显配置，201：月卡车、202：黑名单、203：VIP车辆、204：优惠、205：访客车辆
     */
    private Integer serviceType;

    /**
     * 通道ID，ice_park_inoutdevice表中的id
     */
    private Long channelId;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 设备序列号
     */
    private String sn;

    /**
     * 总条数
     */
    private Integer totalNum;

    /**
     * 成功条数
     */
    private Integer successNum;

    /**
     * 失败条数
     */
    private Integer failNum;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 状态,1：准备中，2：处理中，3：已完成
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
