package com.icetech.park.domain.dto.sms;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import com.icetech.park.domain.entity.sms.SmsAlarmTemplate;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString(callSuper = true)
public class SmsAlarmTemplateDto extends SmsAlarmTemplate {
    /** 车场名称 */
    protected String parkName;
    /**
     * 车场数据采集方式(1-端云;2-端网云;)
     * @see com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum
     */
    protected Integer parkDataCollection;
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime ruleUpdateTime;
    protected String ruleUpdateUser;
}
