package com.icetech.park.domain.dto.sms;

import com.icetech.park.domain.entity.sms.SmsAlarmSendRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsAlarmSendRecordDto extends SmsAlarmSendRecord {
    /** 车场名称 */
    protected String parkName;
    /**
     * 车场数据采集方式(1-端云;2-端网云;)
     * @see com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum
     */
    protected Integer parkDataCollection;
    /** 通道编码 */
    protected String channelCode;
    /** 通道名称 */
    protected String channelName;
}
